<?php
/*
Widget Name: Button - Custom
Description: Button
*/

class Button_Call_Read extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
   
    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'button-call-read',

        // The name of the widget for display purposes.
        'Button - Custom',

        // The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
        array(
            'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
        array(
			'add_class' => array(
				'type' => 'text',
				'label' => "Add Class",						
			),
			'button_color' => array(
				'type' => 'select',
				'label' => __( 'Button color', 'widget-form-fields-text-domain' ),
				'default' => 'black_color',
				'options' => array(
					'blue_color' => __( 'Blue BG', 'widget-form-fields-text-domain' ),
					'yellow_color' => __( 'Yellow BG', 'widget-form-fields-text-domain' ),
					
				)
			), 
			'button_transform' => array(
				'type' => 'select',
				'label' => __( 'Convert Case', 'widget-form-fields-text-domain' ),
				'default' => 'default',
				'options' => array(
					'default' => __( 'None (clear)', 'widget-form-fields-text-domain' ),
					'uppercase' => __( 'UPER CASE', 'widget-form-fields-text-domain' ),
					'lowercase' => __( 'lower case', 'widget-form-fields-text-domain' ),
					'capitalized' => __( 'Capitalized Case', 'widget-form-fields-text-domain' ),
					
				)
			),
			'button_position' => array(
				'type' => 'select',
				'label' => __( 'Button position', 'widget-form-fields-text-domain' ),
				'default' => 'left_button',
				'options' => array(
					'center_button' => __( 'Center', 'widget-form-fields-text-domain' ),
					'left_button' => __( 'Left', 'widget-form-fields-text-domain' ),
					'right_button' => __( 'Right', 'widget-form-fields-text-domain' ),
					
				)
			),
			/* 'button_style' => array(
				'type' => 'select',
				'label' => __( 'Button style', 'widget-form-fields-text-domain' ),
				'default' => 'full_background_btn',
				'options' => array(
					'full_background_btn' => __( 'Full background', 'widget-form-fields-text-domain' ),
					'outline_btn' => __( 'Outline', 'widget-form-fields-text-domain' ),
					
				)
			), */
			'lable-button_a' => array(
				'type' => 'text',
				'label' => "Text Button",						
			),
			'url-button_a' => array(
				'type' => 'link',
				'label' => __('Link button', 'widget-form-fields-text-domain'),
			),
			'target_link' => array(
				'type' => 'select',
				'label' => __( 'Target Link', 'widget-form-fields-text-domain' ),
				'default' => '_self',
				'options' => array(
					'_self' => __( 'Same tab', 'widget-form-fields-text-domain' ),
					'_blank' => __( 'New tab', 'widget-form-fields-text-domain' ),
					
				)
			),

										
			
        ),

        //The $base_folder path string.
        plugin_dir_path(__FILE__)
    );
}
}

siteorigin_widget_register('button-call-read', __FILE__, 'Button_Call_Read');