<?php
/*
Widget Name: Parteners Slider
Description: Parteners Slider
*/

class Clients_slider extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
   
    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'clients-slider',

        // The name of the widget for display purposes.
        'Parteners Slider',

        // The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
        array(
            'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
        array(
			 	
			'list_item' => array(
				'type' => 'repeater',
				'label' => __( 'Parteners slider' , 'widget-form-fields-text-domain' ),
				'item_name'  => __( 'Parteners item', 'siteorigin-widgets' ),
				'item_label' => array(
					'selector'     => "[id*='q']",
					'update_event' => 'change',
					'value_method' => 'val'
				),
				'fields' => array(				 
					
					'link' => array(
						'type' => 'link',
						'label' => __( 'Link', 'widget-form-fields-text-domain' ), 
					),
			
					'icon' => array(
						'type' => 'media',
						'label' => __( 'Image', 'widget-form-fields-text-domain' ),
						'choose' => __( 'Choose image', 'widget-form-fields-text-domain' ),
						'update' => __( 'Set image', 'widget-form-fields-text-domain' ),
						'library' => 'image',
						'fallback' => true
					),
					 
				)
			),
        ),

        //The $base_folder path string.
        plugin_dir_path(__FILE__)
    );
}
}


siteorigin_widget_register('clients-slider', __FILE__, 'Clients_slider');