<?php
/*
Widget Name: Icon Repeater -socials
Description: Icon Repeater
*/

class Icon_Repeater extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
   
    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'icon-repeater',

        // The name of the widget for display purposes.
        'Icon Repeater - Socials',

        // The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
        array(
            'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
		array(
			'title_text' => array(
				'type' => 'text',
				'label' => __('Title socials', 'widget-form-fields-text-domain'),
				'default' => ''
			),
			'list_item' => array(
			'type' => 'repeater',
			'label' => __( 'List item' , 'widget-form-fields-text-domain' ),
			'item_name'  => __( 'Text', 'siteorigin-widgets' ),
			'item_label' => array(
				 'selector'     => "[id*='link']",
				 'update_event' => 'change',
				 'value_method' => 'val'
				),
				'fields' => array(
					 'some_icon' => array(
						'type' => 'icon',
						'label' => __('Select an icon', 'widget-form-fields-text-domain'),
					),
				  'link' => array(
					'type' => 'text',
					'label' => __('Link for icon(will open in new tab)', 'siteorigin-widgets'),
					'default' => ''
				)
			)
		   )
        ),

        //The $base_folder path string.
        plugin_dir_path(__FILE__)
    );
}
}

siteorigin_widget_register('icon-repeater', __FILE__, 'Icon_Repeater');