<?php
/*
Widget Name: Small header
Description: 
*/


class Small_Header extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
    //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'small-header',

        // The name of the widget for display purposes.
        __('Small header', 'simple-widget-text-domain'),
		// The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
        array(
			'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
        array( 
			'large_image' => array(
				'type' => 'media',
				'label' => __( 'Image for background(Lanscape)', 'widget-form-fields-text-domain' ),
				'choose' => __( 'Choose image', 'widget-form-fields-text-domain' ),
				'update' => __( 'Set image', 'widget-form-fields-text-domain' ),
				'library' => 'image',
				'fallback' => true
			),
			'show_title' => array(
				'type' => 'select',
				'label' => __( 'Show title?', 'widget-form-fields-text-domain' ),
				'default' => 'yes',
				'options' => array(
					'yes' => __( 'Yes', 'widget-form-fields-text-domain' ),
					'no' => __( 'No', 'widget-form-fields-text-domain' ),
					
				)
			),
			 'title_header' => array(
				'type' => 'text',
				'label' => __('Title Header', 'widget-form-fields-text-domain'),
				'default' => ''
			),
			
			'subtitle_header' => array(
				'type' => 'text',
				'label' => __('Subtitle Header', 'widget-form-fields-text-domain'),
				'default' => ''
			),
			
	
			
        ),

        //The $base_folder path string.
        plugin_dir_path(__FILE__)
    );
}
	
}

siteorigin_widget_register('small-header', __FILE__, 'Small_Header');